<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-10 10:35:07
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderOther
 */
class OrderOther {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\OrderOther";

    /**
     * 获取加密团购订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GroupOrderDetailDTO
    */
    public static function encodeGroupOrderDetail (string $groupOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeGroupOrderDetail(["groupOrderNum" => $groupOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GroupOrderDetailDTO"
        );
    }
    /**
     * 获取加密零售订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RetailOrderDetailDTO
    */
    public static function encodeRetailOrderDetail (string $encodeOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeRetailOrderDetail(["encodeOrderNum" => $encodeOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RetailOrderDetailDTO"
        );
    }
    /**
     * 获取加密线下订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OfflineOrderDetailDTO
    */
    public static function encodeOfflineOrderDetail (string $encodeOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeOfflineOrderDetail(["encodeOrderNum" => $encodeOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OfflineOrderDetailDTO"
        );
    }
    /**
     * 获取零售订单提货码
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function getRetailOrderCode (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailOrderCode(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }
    /**
     * 获取零售订单提货码V1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function getRetailOrderCodeV1 (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailOrderCodeV1(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}