<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-19 10:45:42
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AggregateOrder
 */
class AggregateOrder {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\AggregateOrder";

    /**
     * 聚合订单-退款申请事件
     * @return  bool
    */
    public static function sendRefundingNotify (string $aggregateOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendRefundingNotify(["aggregateOrderNo" => $aggregateOrderNo]);
    }
    /**
     * 聚合订单-退款成功事件
     * @return  bool
    */
    public static function sendRefundSuccessNotify (string $aggregateOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendRefundSuccessNotify(["aggregateOrderNo" => $aggregateOrderNo]);
    }
    /**
     * 聚合订单-支付抖音订单事件
     * @return  bool
    */
    public static function sendPaidSuccessNotify (string $aggregateOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPaidSuccessNotify(["aggregateOrderNo" => $aggregateOrderNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}