<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-03 17:33:56
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShootingAction
 */
class ShootingAction {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\ShootingAction";

    /**
     * 拍摄动作列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\ShootingActionListDTO
    */
    public static function actionList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\ShootingActionCmd $shootingActionCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->actionList($shootingActionCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\ShootingActionListDTO"
        );
    }
    /**
     * 选定拍摄动作
     * @return  bool
    */
    public static function saveShootingAction (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\SaveShootingActionCmd $saveShootingActionCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveShootingAction($saveShootingActionCmd);
    }
    /**
     * 编辑拍摄动作
     * @return  bool
    */
    public static function editShootingAction (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\SaveShootingActionCmd $saveShootingActionCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editShootingAction($saveShootingActionCmd);
    }
    /**
     * 获取订单拍摄动作
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GetShootingActionListDTO
    */
    public static function getShootingAction (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShootingAction(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GetShootingActionListDTO"
        );
    }
    /**
     * 样片池妆照预览
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\SamplePoolMixedDTO
    */
    public static function samplePoolList (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->samplePoolList(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\SamplePoolMixedDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}