<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-17 10:32:04
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderMessageQueue
 */
class OrderMessageQueue {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\OrderMessageQueue";

    /**
     * 订单完成推送通知
     * @return  bool
    */
    public static function orderComplete (int $orderId, string $watchType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderComplete(["orderId" => $orderId, "watchType" => $watchType]);
    }
    /**
     * 图片处理
     * @return  bool
    */
    public static function creatGifImg (string $photoUrl, int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->creatGifImg(["photoUrl" => $photoUrl, "productId" => $productId]);
    }
    /**
     * 门店签到成功
     * @return  bool
    */
    public static function signSuccess (int $storeId, int $orderId, int $userId, string $module, int $signTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->signSuccess(["storeId" => $storeId, "orderId" => $orderId, "userId" => $userId, "module" => $module, "signTime" => $signTime]);
    }
    /**
     * 订单非自动看片完成事件,发送评价消息
     * @return  bool
    */
    public static function sendEvaluateMessage (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendEvaluateMessage(["orderId" => $orderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}