<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-17 18:43:00
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCache
 */
class ProductCache {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\ProductCache";

    /**
     * 新增产品通知
     * @return  bool
    */
    public static function listenProductAdd (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductAdd(["productId" => $productId]);
    }
    /**
     * 编辑产品通知
     * @return  bool
    */
    public static function listenProductUpdate (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductUpdate(["productId" => $productId]);
    }
    /**
     * 编辑产品组通知
     * @return  bool
    */
    public static function listenCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenCategory(["categoryId" => $categoryId]);
    }
    /**
     * 价格区和门店关联变更
     * @return  bool
    */
    public static function listenChangePriceAreaWithStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangePriceAreaWithStore();
    }
    /**
     * 更新价格区数据
     * @return  bool
    */
    public static function listenUpdatePriceAreaCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenUpdatePriceAreaCache();
    }
    /**
     * 产品服务变更
     * @return  bool
    */
    public static function listenServiceUpdate (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenServiceUpdate(["productId" => $productId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}