<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-25 12:26:36
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\Product";

    /**
     * 编辑产品通知
     * @return  int
    */
    public static function listenUpdateProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenUpdateProduct(["productId" => $productId]);
    }
    /**
     * 编辑类目通知
     * @return  int
    */
    public static function listenUpdateCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenUpdateCategory(["categoryId" => $categoryId]);
    }
    /**
     * 产品和价格变更通知
     * @return  int
    */
    public static function listenChangeProductWithPrice (int $productId, int $priceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeProductWithPrice(["productId" => $productId, "priceId" => $priceId]);
    }
    /**
     * 价格区和门店关联变更通知
     * @return  int
    */
    public static function listenChangePriceAreaWithStore (array $storeIds, int $priceAreaId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangePriceAreaWithStore(["storeIds" => $storeIds, "priceAreaId" => $priceAreaId]);
    }
    /**
     * 产品禁用门店通知
     * @return  bool
    */
    public static function listenChangeBlacklist (array $productIds, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeBlacklist(["productIds" => $productIds, "storeIds" => $storeIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}