<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-24 15:07:16
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Appointment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AppointmentLookPhoto
 */
class AppointmentLookPhoto {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Appointment\\AppointmentLookPhoto";

    /**
     * 预约看片首页
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO
    */
    public static function appointmentLookPhotoData (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentLookPhotoData(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO"
        );
    }
    /**
     * 可预约看片时间列表
     * @return  array
    */
    public static function enableAppointmentTimeList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->enableAppointmentTimeList($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\AppointmentTimeInfoDTO[]"
        );
    }
    /**
     * 设置预约看片时间
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function setAppointmentTime (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->setAppointmentTime(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }
    /**
     * 更改预约看片时间
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function updateAppointmentTime (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateAppointmentTime(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }
    /**
     * 取消预约看片时间
     * @return  bool
    */
    public static function cancelAppointmentTime (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAppointmentTime(["orderNum" => $orderNum]);
    }
    /**
     * 获取可看片门店
     * @return  array
    */
    public static function allowLookPhotoStoreList (string $dateStart, string $dateEnd, string $orderNum, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allowLookPhotoStoreList(["dateStart" => $dateStart, "dateEnd" => $dateEnd, "orderNum" => $orderNum, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]"
        );
    }
    /**
     * 根据日期期间获取预约看片状态是否已约满
     * @return  array
    */
    public static function lookPhotoAppointmentState (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookPhotoAppointmentState($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }
    /**
     * 预约看片时间
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function appointmentLookPhotoTime (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentLookPhotoTime(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }
    /**
     * 预约看片首页.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO
    */
    public static function appointmentLookPhotoDataV1 (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentLookPhotoDataV1(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO"
        );
    }
    /**
     * 可预约看片时间列表.v1
     * @return  array
    */
    public static function enableAppointmentTimeListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->enableAppointmentTimeListV1($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\AppointmentTimeInfoDTO[]"
        );
    }
    /**
     * 设置预约看片时间.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function setAppointmentTimeV1 (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->setAppointmentTimeV1(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }
    /**
     * 更改预约看片时间.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function updateAppointmentTimeV1 (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateAppointmentTimeV1(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }
    /**
     * 取消预约看片时间.v1
     * @return  bool
    */
    public static function cancelAppointmentTimeV1 (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAppointmentTimeV1(["orderNum" => $orderNum]);
    }
    /**
     * 获取可看片门店.v1
     * @return  array
    */
    public static function allowLookPhotoStoreListV1 (string $dateStart, string $dateEnd, string $orderNum, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allowLookPhotoStoreListV1(["dateStart" => $dateStart, "dateEnd" => $dateEnd, "orderNum" => $orderNum, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]"
        );
    }
    /**
     * 根据日期期间获取预约看片状态是否已约满v1
     * @return  array
    */
    public static function lookPhotoAppointmentStateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookPhotoAppointmentStateV1($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }
    /**
     * 预约看片时间V1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
    */
    public static function appointmentLookPhotoTimeV1 (string $orderNum, int $storeId, string $appointmentTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentLookPhotoTimeV1(["orderNum" => $orderNum, "storeId" => $storeId, "appointmentTime" => $appointmentTime]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}