<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-23 15:01:58
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Store\\Store";

    /**
     * 获取当前有门店的所有城市
     * @return  array
    */
    public static function getCitiesByStoreType (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreType(["storeType" => $storeType]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }
    /**
     * 根据城市id获取门店列表[crm也在使用]
     * @return  array
    */
    public static function getStoreListByCityId (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\GetStoreListByCityIdCmd $getStoreListByCityIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId($getStoreListByCityIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }
    /**
     * 根据门店id获取门店详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
    */
    public static function getStoreInfo (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfo(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }
    /**
     * 获取有该产品的门店ids
     * @return  array
    */
    public static function getStoreIdsHaveSameProduct (array $productIds, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameProduct(["productIds" => $productIds, "storeIds" => $storeIds]);
    }
    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     * @return  array
    */
    public static function getStoreIdsHaveSameProductByCityId (int $nodeId, string $type, int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameProductByCityId(["nodeId" => $nodeId, "type" => $type, "cityId" => $cityId]);
    }
    /**
     * 获取当前城市包含这个类目 中 任意 产品的门店ids
     * @return  array
    */
    public static function getStoreIdsHaveSameCategory (int $categoryId, int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameCategory(["categoryId" => $categoryId, "cityId" => $cityId]);
    }
    /**
     * 根据门店ids获取门店信息
     * @return  array
    */
    public static function getStoreListByIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByIds(["storeIds" => $storeIds]);
    }
    /**
     * 获取距离最近的门店[crm也在使用]
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO
    */
    public static function getMostNearestStore (array $location, string $brand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStore(["location" => $location, "brand" => $brand]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO"
        );
    }
    /**
     * 获取门店tab类型
     * @return  array
    */
    public static function getStoreTypes () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTypes(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }
    /**
     * 获取某个门店的产品、套餐树
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO
    */
    public static function getAggregationStoreInfoByStoreId (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\AggregationStoreInfoByStoreIdCmd $aggregationStoreInfoByStoreIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregationStoreInfoByStoreId($aggregationStoreInfoByStoreIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO"
        );
    }
    /**
     * 获取当前有门店的所有城市.v1
     * @return  array
    */
    public static function getCitiesByStoreTypeV1 (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreTypeV1(["storeType" => $storeType]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }
    /**
     * 根据城市id获取门店列表.v1
     * @return  array
    */
    public static function getStoreListByCityIdV1 (array $cityIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityIdV1(["cityIds" => $cityIds]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }
    /**
     * 根据门店id获取门店详情.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
    */
    public static function getStoreInfoV1 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoV1(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }
    /**
     * 获取门店tab类型v1
     * @return  array
    */
    public static function getStoreTypesV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTypesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }
    /**
     * 获取某个门店的产品、套餐树
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO
    */
    public static function getAggregationStoreInfoByStoreIdV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\AggregationStoreInfoByStoreIdCmd $aggregationStoreInfoByStoreIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregationStoreInfoByStoreIdV1($aggregationStoreInfoByStoreIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO"
        );
    }
    /**
     * 获取当前有门店的所有城市.v2
     * @return  array
    */
    public static function getCitiesByStoreTypeV2 (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreTypeV2(["storeType" => $storeType]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }
    /**
     * 根据城市id获取门店列表.v2
     * @return  array
    */
    public static function getStoreListByCityIdV2 (array $cityIds, array $storeType, string $type = 'advanced') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityIdV2(["cityIds" => $cityIds, "storeType" => $storeType, "type" => $type]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}