<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-24 12:07:55
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Reservation
 */
class Reservation {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\Reservation";

    /**
     * 排单表-单门店
     * @return  array
    */
    public static function getReservationList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReservationList($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]"
        );
    }
    /**
     * 排单表-多门店
     * @return  array
    */
    public static function getMultiReservationList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiReservationList($multiReservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]"
        );
    }
    /**
     * 校验订单是否可下单
     * @return  bool
    */
    public static function createOrderOccupyNum (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrderOccupyNum($orderOccupyNumCmd);
    }
    /**
     * 根据日期期间获取是否已约满的状态
     * @return  array
    */
    public static function appointmentState (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentState($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }
    /**
     * 排单表-多门店-分页
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO
    */
    public static function getMultiReservationListByPage (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiReservationListByPage($multiReservationListByPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO"
        );
    }
    /**
     * 获取可拍摄门店IDs
     * @return  array
    */
    public static function getSaleSameProductStores (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSaleSameProductStores($saleSameProductStoresCmd);
    }
    /**
     * 排单表-单门店.v1
     * @return  array
    */
    public static function getReservationListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReservationListV1($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]"
        );
    }
    /**
     * 排单表-多门店.v1
     * @return  array
    */
    public static function getMultiReservationListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiReservationListV1($multiReservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]"
        );
    }
    /**
     * 排单表-多门店-分页.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO
    */
    public static function getMultiReservationListByPageV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiReservationListByPageV1($multiReservationListByPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO"
        );
    }
    /**
     * 校验订单是否可下单.v1
     * @return  bool
    */
    public static function createOrderOccupyNumV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrderOccupyNumV1($orderOccupyNumCmd);
    }
    /**
     * 根据日期期间获取是否已约满的状态.v1
     * @return  array
    */
    public static function appointmentStateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentStateV1($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }
    /**
     * 获取可拍摄门店IDs-v1版本
     * @return  array
    */
    public static function getSaleSameProductStoresV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSaleSameProductStoresV1($saleSameProductStoresCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}