<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-24 12:07:55
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\Order";

    /**
     * 看片通知
     * @return  bool
    */
    public static function sendNormalNotify (int $orderId, string $type, string $module, string $lookPhotoReserveAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNormalNotify(["orderId" => $orderId, "type" => $type, "module" => $module, "lookPhotoReserveAt" => $lookPhotoReserveAt]);
    }
    /**
     * 监听订单服务完成
     * @return  bool
    */
    public static function listenOrderServiceCompleted (int $orderId, string $serviceCompleted, array $orderBaseInfo, array $orderSkuList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderServiceCompleted(["orderId" => $orderId, "serviceCompleted" => $serviceCompleted, "orderBaseInfo" => $orderBaseInfo, "orderSkuList" => $orderSkuList]);
    }
    /**
     * 订单退款通知
     * @return  bool
    */
    public static function sendOrderRefundAsyncNotify (int $orderId, bool $allRefund, int $refundId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendOrderRefundAsyncNotify(["orderId" => $orderId, "allRefund" => $allRefund, "refundId" => $refundId]);
    }
    /**
     * 取消订单事件监听
     * @return  bool
    */
    public static function listenOrderCancel (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderCancel(["orderNo" => $orderNo]);
    }
    /**
     * 监听订单支付事件
     * @return  bool
    */
    public static function listenOrderPaidOrder (int $orderId, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderPaidOrder(["orderId" => $orderId, "payType" => $payType, "paymentNo" => $paymentNo]);
    }
    /**
     * 监听订单状态变更事件
     * @return  bool
    */
    public static function listenOrderStatusUpdate (int $orderId, string $oldStatus, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderStatusUpdate(["orderId" => $orderId, "oldStatus" => $oldStatus, "status" => $status]);
    }
    /**
     * 监听订单看片完成事件
     * @return  bool
    */
    public static function listenOrderLookPhoto (int $orderId, string $lookPhotoCompletedAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderLookPhoto(["orderId" => $orderId, "lookPhotoCompletedAt" => $lookPhotoCompletedAt]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}