<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-22 17:49:46
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord;

class UpdateSharePhotoRecordCmd {
    /**
     * @var  string
     * 分享记录的id
     * validation: 
     */
    public string $shareRecordId;
    /**
     * @var  string
     * 分享类型 
     * validation: required|in:normal,appoint
     */
    public string $shareType;
    /**
     * @var  string[]
     * 白名单手机数组
     * validation: required_unless:shareType,normal|max:10
     */
    public array $whitePhones;

    public function __construct (int $userId = 0, string $shareRecordId = '', string $shareType = '', array $whitePhones = []) {
        $this->userId = $userId;
        $this->shareRecordId = $shareRecordId;
        $this->shareType = $shareType;
        $this->whitePhones = $whitePhones;
    }

    public static function create(int $userId = 0, string $shareRecordId = '', string $shareType = '', array $whitePhones = []): self {
        return new self($userId, $shareRecordId, $shareType, $whitePhones);
    }

    public function setShareRecordId(string $shareRecordId): self {
        $this->shareRecordId = $shareRecordId;

        return $this;
    }

    public function setShareType(string $shareType): self {
        $this->shareType = $shareType;

        return $this;
    }

    public function setWhitePhones(array $whitePhones): self {
        $this->whitePhones = $whitePhones;

        return $this;
    }
}