<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-09 17:40:15
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder;

class RetailOrderInfoDTO {
    /**
     * @var  int
     * 零售订单ID
     * validation: 
     */
    public int $retailOrderId;
    /**
     * @var  string
     * 零售订单编号
     * validation: 
     */
    public string $retailOrderNo;
    /**
     * @var  int
     * 零售订单门店id
     * validation: 
     */
    public int $storeId;
    /**
     * @var  string
     * 用户名称
     * validation: 
     */
    public string $userName;
    /**
     * @var  string
     * 用户手机号
     * validation: 
     */
    public string $userPhone;
    /**
     * @var  float
     * 订单价格
     * validation: 
     */
    public float $money;
    /**
     * @var  float
     * 订单原价
     * validation: 
     */
    public float $originalMoney;
    /**
     * @var  float
     * 订单实际价格
     * validation: 
     */
    public float $realMoney;
    /**
     * @var  float
     * 礼品卡支付金额
     * validation: 
     */
    public float $giftCardMoney;
    /**
     * @var  string
     * 订单来源
     * validation: 
     */
    public string $source;
    /**
     * @var  string
     * 订单状态
     * validation: 
     */
    public string $status;
    /**
     * @var  string
     * 订单退款状态
     * validation: 
     */
    public string $refundStatus = "";
    /**
     * @var  string[]
     * 已提货商品名称
     * validation: 
     */
    public array $alreadyPickUpGoods = [];
    /**
     * @var  bool
     * 是否可退款 isRefund = false ,则为不能退款 alreadyPickUpGoods 表示已经有已提货的产品， 为空则表示 当前订单 有已经申请退款的商品 所以不能退款
     * validation: 
     */
    public bool $isRefund = false;
    /**
     * @var  bool
     * 是否展示退款按钮
     * validation: 
     */
    public bool $showRefund = false;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\RetailProductDTO[]
     * 零售产品
     * validation: 
     */
    public array $retailProducts = [];

    public function __construct (int $retailOrderId = 0, string $retailOrderNo = '', int $storeId = 0, string $userName = '', string $userPhone = '', float $money = 0.0, float $originalMoney = 0.0, float $realMoney = 0.0, float $giftCardMoney = 0.0, string $source = '', string $status = '') {
        $this->retailOrderId = $retailOrderId;
        $this->retailOrderNo = $retailOrderNo;
        $this->storeId = $storeId;
        $this->userName = $userName;
        $this->userPhone = $userPhone;
        $this->money = $money;
        $this->originalMoney = $originalMoney;
        $this->realMoney = $realMoney;
        $this->giftCardMoney = $giftCardMoney;
        $this->source = $source;
        $this->status = $status;
    }

    public static function create(int $retailOrderId = 0, string $retailOrderNo = '', int $storeId = 0, string $userName = '', string $userPhone = '', float $money = 0.0, float $originalMoney = 0.0, float $realMoney = 0.0, float $giftCardMoney = 0.0, string $source = '', string $status = ''): self {
        return new self($retailOrderId, $retailOrderNo, $storeId, $userName, $userPhone, $money, $originalMoney, $realMoney, $giftCardMoney, $source, $status);
    }

    public function setRetailOrderId(int $retailOrderId): self {
        $this->retailOrderId = $retailOrderId;

        return $this;
    }

    public function setRetailOrderNo(string $retailOrderNo): self {
        $this->retailOrderNo = $retailOrderNo;

        return $this;
    }

    public function setStoreId(int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setUserPhone(string $userPhone): self {
        $this->userPhone = $userPhone;

        return $this;
    }

    public function setMoney(float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setOriginalMoney(float $originalMoney): self {
        $this->originalMoney = $originalMoney;

        return $this;
    }

    public function setRealMoney(float $realMoney): self {
        $this->realMoney = $realMoney;

        return $this;
    }

    public function setGiftCardMoney(float $giftCardMoney): self {
        $this->giftCardMoney = $giftCardMoney;

        return $this;
    }

    public function setSource(string $source): self {
        $this->source = $source;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setRefundStatus(string $refundStatus): self {
        $this->refundStatus = $refundStatus;

        return $this;
    }

    public function setAlreadyPickUpGoods(array $alreadyPickUpGoods): self {
        $this->alreadyPickUpGoods = $alreadyPickUpGoods;

        return $this;
    }

    public function setIsRefund(bool $isRefund): self {
        $this->isRefund = $isRefund;

        return $this;
    }

    public function setShowRefund(bool $showRefund): self {
        $this->showRefund = $showRefund;

        return $this;
    }

    public function setRetailProducts(array $retailProducts): self {
        $this->retailProducts = $retailProducts;

        return $this;
    }
}