<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 15:10:53
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShareOrder
 */
class ShareOrder {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\ShareOrder";

    /**
     * 获得买家秀列表
     */
    public static function getShareOrderList (int $categoryId, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderList(["categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }
    /**
     * 获得晒单类目数据
     */
    public static function getShareOrderCategories (string $orderNum): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderCategories(["orderNum" => $orderNum, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }
    /**
     * 提交晒单数据
     */
    public static function createShareOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createShareOrder($shareOrderCreateCmd);
    }
    /**
     * 删除买家秀
     */
    public static function deleteShareOrder (int $shareId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShareOrder(["shareId" => $shareId, ]);
    }
    /**
     * 获得买家秀列表.V1
     */
    public static function getShareOrderListV1 (int $categoryId, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderListV1(["categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }
    /**
     * 获得晒单类目数据.v1
     */
    public static function getShareOrderCategoriesV1 (string $orderNum): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderCategoriesV1(["orderNum" => $orderNum, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }
    /**
     * 提交晒单数据.V1
     */
    public static function createShareOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createShareOrderV1($shareOrderCreateCmd);
    }
    /**
     * 删除买家秀.v1
     */
    public static function deleteShareOrderV1 (int $shareId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShareOrderV1(["shareId" => $shareId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}