<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-16 19:26:51
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CompanyShoot;

class AddCompanyShootCmd {
    /**
     * @var  int
     * 唯一id
     * validation: 
     */
    public int $uniqueId;
    /**
     * @var  string
     * 联系人姓名
     * validation: 
     */
    public string $contactName;
    /**
     * @var  string
     * 联系人手机号
     * validation: min:11|max:11
     */
    public string $contactPhone;
    /**
     * @var  string
     * 企业名称
     * validation: 
     */
    public string $companyName;
    /**
     * @var  string
     * 备注留言
     * validation: 
     */
    public string $remark = "";
    /**
     * @var  string[]
     * 拍摄需求
     * validation: 
     */
    public array $shootDemand;
    /**
     * @var  string
     * 拍摄方式
     * validation: 
     */
    public string $shootWay;
    /**
     * @var  string
     * 拍摄时间
     * validation: date_format:Y-m
     */
    public string $shootTime;
    /**
     * @var  string
     * 拍摄人数类型A:1O人以内,B:10-30人,C:30-100人,D:100-300人,E:300人以上
     * validation: required|in:A,B,C,D,E
     */
    public string $shootPeopleNumType;
    /**
     * @var  int
     * 拍摄城市id
     * validation: 
     */
    public int $shootCityId;
    /**
     * @var  null|int
     * 拍摄省份id
     * validation: 
     */
    public ?int $shootProvinceId = null;

    public function __construct (int $uniqueId = 0, string $contactName = '', string $contactPhone = '', string $companyName = '', array $shootDemand = [], string $shootWay = '', string $shootTime = '', string $shootPeopleNumType = '', int $shootCityId = 0) {
        $this->uniqueId = $uniqueId;
        $this->contactName = $contactName;
        $this->contactPhone = $contactPhone;
        $this->companyName = $companyName;
        $this->shootDemand = $shootDemand;
        $this->shootWay = $shootWay;
        $this->shootTime = $shootTime;
        $this->shootPeopleNumType = $shootPeopleNumType;
        $this->shootCityId = $shootCityId;
    }

    public static function create(int $uniqueId = 0, string $contactName = '', string $contactPhone = '', string $companyName = '', array $shootDemand = [], string $shootWay = '', string $shootTime = '', string $shootPeopleNumType = '', int $shootCityId = 0): self {
        return new self($uniqueId, $contactName, $contactPhone, $companyName, $shootDemand, $shootWay, $shootTime, $shootPeopleNumType, $shootCityId);
    }

    public function setUniqueId(int $uniqueId): self {
        $this->uniqueId = $uniqueId;

        return $this;
    }

    public function setContactName(string $contactName): self {
        $this->contactName = $contactName;

        return $this;
    }

    public function setContactPhone(string $contactPhone): self {
        $this->contactPhone = $contactPhone;

        return $this;
    }

    public function setCompanyName(string $companyName): self {
        $this->companyName = $companyName;

        return $this;
    }

    public function setRemark(string $remark): self {
        $this->remark = $remark;

        return $this;
    }

    public function setShootDemand(array $shootDemand): self {
        $this->shootDemand = $shootDemand;

        return $this;
    }

    public function setShootWay(string $shootWay): self {
        $this->shootWay = $shootWay;

        return $this;
    }

    public function setShootTime(string $shootTime): self {
        $this->shootTime = $shootTime;

        return $this;
    }

    public function setShootPeopleNumType(string $shootPeopleNumType): self {
        $this->shootPeopleNumType = $shootPeopleNumType;

        return $this;
    }

    public function setShootCityId(int $shootCityId): self {
        $this->shootCityId = $shootCityId;

        return $this;
    }

    public function setShootProvinceId(?int $shootProvinceId): self {
        $this->shootProvinceId = $shootProvinceId;

        return $this;
    }
}