<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-08 11:03:15
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 */
class User {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\User";

    /**
     * 用户详情[crm也在使用]
     *
     */
    public static function detail (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 修改用户信息
     *
     */
    public static function editUserInfo (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserInfo($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 修改用户标签
     *
     */
    public static function editUserTag (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserTagCmd $editUserTagCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserTag($editUserTagCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 职业列表[crm也在使用]
     *
     */
    public static function getProfessions (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProfessions(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]"
        );
    }
    /**
     * 偏好列表
     *
     */
    public static function getPreferences (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferences(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO"
        );
    }
    /**
     * 绑定邮箱校验是否通过验证
     *
     */
    public static function checkSign (string $brand, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkSign(["brand" => $brand, "user_id" => $user_id, ]);
    }
    /**
     * 记录预约协议版本
     *
     */
    public static function setProtocolVersion (int $protocolVersion): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProtocolVersion(["protocolVersion" => $protocolVersion, ]);
    }
    /**
     * 用户意见反馈
     *
     */
    public static function feedback (string $content): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedback(["content" => $content, ]);
    }
    /**
     * 更改密码（密码为空）
     *
     */
    public static function changePasswordDirect (string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePasswordDirect(["password" => $password, ]);
    }
    /**
     * 通过验证码更改登录密码
     *
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "password" => $password, "captcha" => $captcha, ]);
    }
    /**
     * 注销帐号.old
     *
     */
    public static function cancel (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel();
    }
    /**
     * 通过unionId判断用户是否在海马体平台注册过
     *
     */
    public static function searchUserByUnionId (string $unionId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUserByUnionId(["unionId" => $unionId, ]);
    }
    /**
     * 更改密码
     *
     */
    public static function changUserPassword (string $password, string $passwordNew): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPassword(["password" => $password, "passwordNew" => $passwordNew, ]);
    }
    /**
     * 注销帐号.new
     *
     */
    public static function close (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->close(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO"
        );
    }
    /**
     * 获取用户ID
     *
     */
    public static function simplyDetail (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserSimplyDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->simplyDetail(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserSimplyDetailDTO"
        );
    }
    /**
     * 用户详情.v1
     *
     */
    public static function detailV1 (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 修改用户信息.v1
     *
     */
    public static function editUserInfoV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserInfoV1($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 修改用户标签.v1
     *
     */
    public static function editUserTagV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserTagCmd $editUserTagCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserTagV1($editUserTagCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 职业列表.v1
     *
     */
    public static function getProfessionsV1 (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProfessionsV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]"
        );
    }
    /**
     * 偏好列表.v1
     *
     */
    public static function getPreferencesV1 (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferencesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO"
        );
    }
    /**
     * 记录预约协议版本.v1
     *
     */
    public static function setProtocolVersionV1 (int $protocolVersion): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProtocolVersionV1(["protocolVersion" => $protocolVersion, ]);
    }
    /**
     * 用户意见反馈.v1
     *
     */
    public static function feedbackV1 (string $content): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedbackV1(["content" => $content, ]);
    }
    /**
     * 更改密码（密码为空）.v1
     *
     */
    public static function changePasswordDirectV1 (string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePasswordDirectV1(["password" => $password, ]);
    }
    /**
     * 通过验证码更改登录密码.v1
     *
     */
    public static function forgetUserPasswordV1 (string $phone, string $password, string $captcha): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPasswordV1(["phone" => $phone, "password" => $password, "captcha" => $captcha, ]);
    }
    /**
     * 更改密码.v1
     *
     */
    public static function changUserPasswordV1 (string $password, string $passwordNew): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPasswordV1(["password" => $password, "passwordNew" => $passwordNew, ]);
    }
    /**
     * 注销帐号.v1
     *
     */
    public static function cancelV1 (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelV1();
    }
    /**
     * 注销帐号.new.v1
     *
     */
    public static function closeV1 (): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->closeV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}