<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method ownListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\OwnListCmd $params)
 * @method getListByParams(array $params)
 * @method getTopicListByParams(array $params)
 * @method chargeByParams(array $params)
 * @method createOrderByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CreateGiftCardOrderCmd $params)
 * @method orderDetailByParams(array $params)
 * @method giveByParams(array $params)
 * @method giveDetailByParams(array $params)
 * @method confirmGiveByParams(array $params)
 * @method receiveGiveByParams(array $params)
 * @method cancelGiveByParams(array $params)
 * @method getGiftCardFaceValueConfigByParams(array $params)
 * @method getGiftCardFaceValueConfigV1ByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户礼品卡列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\OwnListCmd $ownListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\OwnGiftCardInfoDTO[]
     */
    public static function ownList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\OwnListCmd $ownListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->ownList($ownListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\OwnGiftCardInfoDTO[]"
        );
    }


    /**
     * 礼品卡列表
     *
     * @support  int $page 分页 [ require false ]
     * @support  int $pageSize 每页数据量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardSeriesDTO[]
     */
    public static function getList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardSeriesDTO[]"
        );
    }

    /**
     * 获取礼品卡主题信息
     *
     * @support  int $topicId id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO
     */
    public static function getTopicList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTopicList([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO"
        );
    }

    /**
     * 充值礼品码
     *
     * @support  string $giftCardCode 礼品码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function charge () {
        return self::getClass()->charge([
        ]);
    }

    /**
     * 用户购买礼品卡
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CreateGiftCardOrderCmd $createGiftCardOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO
     */
    public static function createOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CreateGiftCardOrderCmd $createGiftCardOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createOrder($createGiftCardOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO"
        );
    }


    /**
     * 获取单个礼品卡订单详情
     *
     * @support  string $orderNum 礼品卡订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardOrderInfoDTO[]
     */
    public static function orderDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardOrderInfoDTO[]"
        );
    }

    /**
     * 礼品卡赠送
     *
     * @support  int $giftCardId 要送的礼品卡ID [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO
     */
    public static function give () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->give([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO"
        );
    }

    /**
     * 获取赠送详情
     *
     * @support  string $code 加密后的推送code [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO
     */
    public static function giveDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->giveDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO"
        );
    }

    /**
     * 确认推送
     *
     * @support  string $code 赠送记录code [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmGive () {
        return self::getClass()->confirmGive([
        ]);
    }

    /**
     * 接受赠送
     *
     * @support  string $code 赠送code [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveGive () {
        return self::getClass()->receiveGive([
        ]);
    }

    /**
     * 取消推送
     *
     * @support  int $giveRecordId 赠送记录ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelGive () {
        return self::getClass()->cancelGive([
        ]);
    }

    /**
     * 获取礼品卡面值配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO
     */
    public static function getGiftCardFaceValueConfig () {
        return self::getClass()->getGiftCardFaceValueConfig();
    }

    /**
     * 获取礼品卡面值配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO
     */
    public static function getGiftCardFaceValueConfigV1 () {
        return self::getClass()->getGiftCardFaceValueConfigV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}