<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBirthGiftByParams(array $params)
 * @method exchangeBirthGiftByParams(array $params)
 * @method hasSentBirthCouponByParams(array $params)
 * @method setMemberUpgradeTagByParams(array $params)
 * @method alertCheckByParams(array $params)
 * @method listWelfareByParams(array $params)
 * @method listWelfareWithBirthGiftWaitingStatusByParams(array $params)
 * @method listMemberActivitiesByParams(array $params)
 * @method receiveWelfareRetailByParams(array $params)
 * @method getUserPointRecordsByParams(array $params)
 * @method getUserBrandsByParams(array $params)
 * @method memberRulesByParams(array $params)
 * @method getBirthGiftV1ByParams(array $params)
 * @method exchangeBirthGiftV1ByParams(array $params)
 * @method setMemberUpgradeTagV1ByParams(array $params)
 * @method alertCheckV1ByParams(array $params)
 * @method listWelfareV1ByParams(array $params)
 * @method listMemberActivitiesV1ByParams(array $params)
 * @method receiveWelfareRetailV1ByParams(array $params)
 * @method getUserPointRecordsV1ByParams(array $params)
 * @method getUserBrandsV1ByParams(array $params)
 * @method memberRulesV1ByParams(array $params)
 * @method listMemberActivitiesV2ByParams(array $params)
 * @method getUserPointRecordsV2ByParams(array $params)
 */
class UserMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户获取生日礼遇零售产品
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO
     */
    public static function getBirthGift (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBirthGift([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO"
        );
    }

    /**
     * 兑换生日礼遇
     *
     * @param  int $orderId 预约订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
     */
    public static function exchangeBirthGift (int $userId, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->exchangeBirthGift([
                            "userId" => $userId,
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 用户是否已发送生日券[crm也在使用]
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $year 年份，默认今年，如 2021 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hasSentBirthCoupon (int $userId, string $year = '') {
        return self::getClass()->hasSentBirthCoupon([
            "userId" => $userId,
            "year" => $year,
        ]);
    }

    /**
     * 添加新版会员弹框记录
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setMemberUpgradeTag (int $userId) {
        return self::getClass()->setMemberUpgradeTag([
            "userId" => $userId,
        ]);
    }

    /**
     * 删除会员升级弹框标记
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function alertCheck (int $userId) {
        return self::getClass()->alertCheck([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员权益
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberWelfare\WelfareDetailDTO[]
     */
    public static function listWelfare (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWelfare([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberWelfare\WelfareDetailDTO[]"
        );
    }

    /**
     * 获取会员权益.bridge
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWelfareWithBirthGiftWaitingStatus () {
        return self::getClass()->listWelfareWithBirthGiftWaitingStatus([
        ]);
    }

    /**
     * 会员活动列表
     *
     * @param  array $types 活动类型, banner banner图, complete_info 用户相关, 默认查询所有类型 [ require false ]
     * @param  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]
     */
    public static function listMemberActivities (array $types = [], int $userId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listMemberActivities([
                            "types" => $types,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]"
        );
    }

    /**
     * 领取权益美学生活礼遇
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
     */
    public static function receiveWelfareRetail (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->receiveWelfareRetail([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 获取用户纪念值记录
     *
     * @param  int $userId 用户id [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
     */
    public static function getUserPointRecords (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserPointRecords([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }

    /**
     * 获取用户品牌探索标签
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]
     */
    public static function getUserBrands (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserBrands([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]"
        );
    }

    /**
     * 获取会员升级规则
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserMember\UserMemberRuleDTO[]
     */
    public static function memberRules () {
        return self::getClass()->memberRules();
    }

    /**
     * 用户获取生日礼遇零售产品.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO
     */
    public static function getBirthGiftV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBirthGiftV1([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO"
        );
    }

    /**
     * 兑换生日礼遇.v1
     *
     * @param  int $orderId 预约订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
     */
    public static function exchangeBirthGiftV1 (int $userId, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->exchangeBirthGiftV1([
                            "userId" => $userId,
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 添加新版会员弹框记录.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setMemberUpgradeTagV1 (int $userId) {
        return self::getClass()->setMemberUpgradeTagV1([
            "userId" => $userId,
        ]);
    }

    /**
     * 删除会员升级弹框标记.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function alertCheckV1 (int $userId) {
        return self::getClass()->alertCheckV1([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员权益.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWelfareV1 (int $userId) {
        return self::getClass()->listWelfareV1([
            "userId" => $userId,
        ]);
    }

    /**
     * 会员活动列表.v1
     *
     * @param  array $types 活动类型, banner banner图, complete_info 用户相关, 默认查询所有类型 [ require false ]
     * @param  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]
     */
    public static function listMemberActivitiesV1 (array $types = [], int $userId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listMemberActivitiesV1([
                            "types" => $types,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]"
        );
    }

    /**
     * 领取权益美学生活礼遇.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
     */
    public static function receiveWelfareRetailV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->receiveWelfareRetailV1([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 获取用户纪念值记录.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
     */
    public static function getUserPointRecordsV1 (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserPointRecordsV1([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }

    /**
     * 获取用户品牌探索标签.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]
     */
    public static function getUserBrandsV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserBrandsV1([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]"
        );
    }

    /**
     * 获取会员升级规则v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserMember\UserMemberRuleDTO[]
     */
    public static function memberRulesV1 () {
        return self::getClass()->memberRulesV1();
    }

    /**
     * 会员活动列表.v2
     *
     * @param  array $types 活动类型, banner banner图, complete_info 用户相关, 默认查询所有类型 [ require false ]
     * @param  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]
     */
    public static function listMemberActivitiesV2 (array $types = [], int $userId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listMemberActivitiesV2([
                            "types" => $types,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]"
        );
    }

    /**
     * 获取用户纪念值记录.v2
     *
     * @param  int $userId 用户id [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
     */
    public static function getUserPointRecordsV2 (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserPointRecordsV2([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}