<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPhotoAlbumsByParams(array $params)
 * @method createSharePhotoRecordByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $params)
 * @method updateSharePhotoRecordByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\UpdateSharePhotoRecordCmd $params)
 * @method getShareRecordDetailByParams(array $params)
 * @method saveSharePhotosByParams(array $params)
 * @method getPictureMeasureByParams(array $params)
 * @method getPictureTypeByParams(array $params)
 * @method deleteSharePhotoByParams(array $params)
 * @method listPhotoAlbumsV1ByParams(array $params)
 * @method createSharePhotoRecordV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $params)
 * @method getShareRecordDetailV1ByParams(array $params)
 * @method saveSharePhotosV1ByParams(array $params)
 * @method getPictureTypeV1ByParams(array $params)
 * @method getPictureMeasureV1ByParams(array $params)
 * @method deleteSharePhotoV1ByParams(array $params)
 */
class PhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的相册
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @support  string $lastOrderReserveTime 上一页最后预约时间 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO
     */
    public static function listPhotoAlbums () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listPhotoAlbums([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO"
        );
    }

    /**
     * 相册分享记录.创建
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO
     */
    public static function createSharePhotoRecord (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createSharePhotoRecord($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO"
        );
    }


    /**
     * 相册分享记录.更新
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\UpdateSharePhotoRecordCmd $updateSharePhotoRecordCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSharePhotoRecord (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\UpdateSharePhotoRecordCmd $updateSharePhotoRecordCmd) {
        return self::getClass()->updateSharePhotoRecord($updateSharePhotoRecordCmd);
    }


    /**
     * 分享记录详情
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO
     */
    public static function getShareRecordDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareRecordDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO"
        );
    }

    /**
     * 保存分享数据到我的相册
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO
     */
    public static function saveSharePhotos () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->saveSharePhotos([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO"
        );
    }

    /**
     * 获取照片裁剪尺寸信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PictureMeasureDetailDTO[]
     */
    public static function getPictureMeasure () {
        return self::getClass()->getPictureMeasure();
    }

    /**
     * 获得图片类型
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureType([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * 删除共享的照片
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteSharePhoto () {
        return self::getClass()->deleteSharePhoto([
        ]);
    }

    /**
     * 我的相册.v1
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @support  string $lastOrderReserveTime 上一页最后预约时间 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO
     */
    public static function listPhotoAlbumsV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listPhotoAlbumsV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO"
        );
    }

    /**
     * 相册分享记录.创建.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO
     */
    public static function createSharePhotoRecordV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createSharePhotoRecordV1($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO"
        );
    }


    /**
     * 分享记录详情.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO
     */
    public static function getShareRecordDetailV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareRecordDetailV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO"
        );
    }

    /**
     * 保存分享数据到我的相册.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO
     */
    public static function saveSharePhotosV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->saveSharePhotosV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO"
        );
    }

    /**
     * 获得图片类型.v1
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureTypeV1 (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureTypeV1([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * 获取照片裁剪尺寸信息v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PictureMeasureDetailDTO[]
     */
    public static function getPictureMeasureV1 () {
        return self::getClass()->getPictureMeasureV1();
    }

    /**
     * 删除共享的照片
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteSharePhotoV1 () {
        return self::getClass()->deleteSharePhotoV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}