<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-23 15:50:18
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Product\\Product";

    /**
     * 获取产品详情.需门店
     *
     */
    public static function getProductDetailInStore (int $storeId, int $productId): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductDetailInStore(["storeId" => $storeId, "productId" => $productId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO"
        );
    }
    /**
     * 获取所有产品
     *
     */
    public static function getAllProducts (int $storeId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProducts(["storeId" => $storeId, ]);
    }
    /**
     * 获取某个门店的产品树
     *
     */
    public static function productTree (int $storeId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTree(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }
    /**
     * 获取一个门店下某个类目所有的产品[crm也在使用]
     *
     */
    public static function getCategoryProductsByStoreId (int $categoryId, int $storeId): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreId(["categoryId" => $categoryId, "storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }
    /**
     * 根据类目ids获取类目
     *
     */
    public static function categories (array $categoryIds, int $cityId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categories(["categoryIds" => $categoryIds, "cityId" => $cityId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }
    /**
     * 过滤出有该类目的门店ids
     *
     */
    public static function haveCategoryStoreIds (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\SameNodeStoreIdsCmd $sameNodeStoreIdsCmd = null): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveCategoryStoreIds($sameNodeStoreIdsCmd);
    }
    /**
     * 获取赠品规则
     *
     */
    public static function getProductGiftRule (int $nodeId, string $startAt, string $endAt, string $group): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductGiftRule(["nodeId" => $nodeId, "startAt" => $startAt, "endAt" => $endAt, "group" => $group, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\GiftRule\GiftRuleDTO[]"
        );
    }
    /**
     * 产品搜索
     *
     */
    public static function productSearch (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductSearchCmd $productSearchCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSearch($productSearchCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }
    /**
     * 校验产品占点
     *
     */
    public static function checkProductCouldOccupy (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductCouldOccupy($checkProductCouldOccupyCmd);
    }
    /**
     * 获取所有产品.v1
     *
     */
    public static function getAllProductsV1 (int $storeId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductsV1(["storeId" => $storeId, ]);
    }
    /**
     * 获取某个门店的产品树v1
     *
     */
    public static function productTreeV1 (int $storeId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productTreeV1(["storeId" => $storeId, ]);
    }
    /**
     * 根据类目ids获取类目.v1
     *
     */
    public static function categoriesV1 (array $categoryIds, int $cityId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categoriesV1(["categoryIds" => $categoryIds, "cityId" => $cityId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }
    /**
     * 获取一个门店下某个类目所有的产品.v1
     *
     */
    public static function getCategoryProductsByStoreIdV1 (int $categoryId, int $storeId): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreIdV1(["categoryId" => $categoryId, "storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }
    /**
     * 产品搜索v1
     *
     */
    public static function productSearchV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductSearchCmd $productSearchCmd): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSearchV1($productSearchCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }
    /**
     * 校验产品占点v1
     *
     */
    public static function checkProductCouldOccupyV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductCouldOccupyV1($checkProductCouldOccupyCmd);
    }
    /**
     * 获得猜你喜欢.v2
     *
     */
    public static function getProductYouLikeV2 (string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductYouLikeV2(["brand" => $brand, ]);
    }
    /**
     * 获取某个门店的产品树v2
     *
     */
    public static function productTreeV2 (int $storeId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTreeV2(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }
    /**
     * 获取一个门店下某个类目所有的产品.v2
     *
     */
    public static function getCategoryProductsByStoreIdV2 (int $categoryId, int $storeId): \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreIdV2(["categoryId" => $categoryId, "storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }
    /**
     * 获取某个门店的产品树v3
     *
     */
    public static function productTreeV3 (int $storeId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTreeV3(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}