<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvisibleCaptchaV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\InvisibleCaptchaCmd $params)
 * @method getSmsCodeWithInvisibleV1ByParams(array $params)
 * @method getGeeTestRegisterByParams(array $params)
 * @method getGeeTestValidateByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $params)
 * @method getSmsCodeByTokenByParams(array $params)
 * @method getSmsCodeByTokenV1ByParams(array $params)
 * @method getGeeTestRegisterV1ByParams(array $params)
 * @method getGeeTestValidateV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $params)
 * @method isSubscribeWxAppNotifyByParams(array $params)
 * @method subscribeWxAppNotifyByParams(array $params)
 * @method sendNotifyMessageByParams(array $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [腾讯]无痕验证.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\InvisibleCaptchaCmd $invisibleCaptchaCmd
     * @throws  \Exception
     * @return  string
     */
    public static function getInvisibleCaptchaV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\InvisibleCaptchaCmd $invisibleCaptchaCmd) {
        return self::getClass()->getInvisibleCaptchaV1($invisibleCaptchaCmd);
    }


    /**
     * 通过无痕验证后发送短信验证码.v1 最近调用时间在21年12月
     *
     * @param  string $type 发送类型，默认：haimati_sms_code [ require false ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getSmsCodeWithInvisibleV1 (string $type = 'haimati_sms_code', string $phone, string $token) {
        return self::getClass()->getSmsCodeWithInvisibleV1([
            "type" => $type,
            "phone" => $phone,
            "token" => $token,
        ]);
    }

    /**
     * 极验初始化验证
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO
     */
    public static function getGeeTestRegister () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGeeTestRegister([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO"
        );
    }

    /**
     * 二次验证
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd
     * @throws  \Exception
     * @return  string
     */
    public static function getGeeTestValidate (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd) {
        return self::getClass()->getGeeTestValidate($geeTestValidateCmd);
    }


    /**
     * 根据token发送短信验证码
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 发送手机号码 [ require false ]
     * @support  string $token Token [ require true ]
     * @support  string $tokenType token类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getSmsCodeByToken () {
        return self::getClass()->getSmsCodeByToken([
        ]);
    }

    /**
     * 根据token发送验证码
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 发送手机号码 [ require false ]
     * @support  string $token Token [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getSmsCodeByTokenV1 () {
        return self::getClass()->getSmsCodeByTokenV1([
        ]);
    }

    /**
     * 极验初始化验证/v1
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO
     */
    public static function getGeeTestRegisterV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGeeTestRegisterV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO"
        );
    }

    /**
     * 二次验证/v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd
     * @throws  \Exception
     * @return  string
     */
    public static function getGeeTestValidateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd) {
        return self::getClass()->getGeeTestValidateV1($geeTestValidateCmd);
    }


    /**
     * 是否已经订阅微信app通知
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $event 通知的消息名称，参考EventNameEnum枚举值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isSubscribeWxAppNotify () {
        return self::getClass()->isSubscribeWxAppNotify([
        ]);
    }

    /**
     * 订阅微信app通知
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $event 通知的消息名称，参考EventNameEnum枚举值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function subscribeWxAppNotify () {
        return self::getClass()->subscribeWxAppNotify([
        ]);
    }

    /**
     * 每5分钟执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNotifyMessage () {
        return self::getClass()->sendNotifyMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}