<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productCardListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $params)
 * @method multiProductCardListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $params)
 * @method productCardListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $params)
 * @method multiProductCardListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品卡列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO
     */
    public static function productCardList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productCardList($productCardListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO"
        );
    }


    /**
     * 多品牌产品卡列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $multiProductCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO
     */
    public static function multiProductCardList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $multiProductCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->multiProductCardList($multiProductCardListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO"
        );
    }


    /**
     * 产品卡列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO
     */
    public static function productCardListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productCardListV1($productCardListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO"
        );
    }


    /**
     * 多品牌产品卡列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $multiProductCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO
     */
    public static function multiProductCardListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiProductCardListCmd $multiProductCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->multiProductCardListV1($multiProductCardListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}