<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bannerListByParams(array $params)
 * @method resourceDataByParams(array $params)
 * @method productDeployClassificationByParams(array $params)
 * @method productDeployListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UndertakePage\ProductDeployListCmd $params)
 * @method productDeployListAllGroupByClassificationByParams(array $params)
 * @method resourceDataV1ByParams(array $params)
 */
class UndertakePage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取banner图列表
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\BannerDTO[]
     */
    public static function bannerList (string $brand, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bannerList([
                            "brand" => $brand,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\BannerDTO[]"
        );
    }

    /**
     * 获取资源位配置
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ResourcePositionInfoDTO[]
     */
    public static function resourceData (string $brand, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->resourceData([
                            "brand" => $brand,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ResourcePositionInfoDTO[]"
        );
    }

    /**
     * 产品配置类目
     *
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployClassificationInfoDTO[]
     */
    public static function productDeployClassification (string $brand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productDeployClassification([
                            "brand" => $brand,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployClassificationInfoDTO[]"
        );
    }

    /**
     * 产品配置列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UndertakePage\ProductDeployListCmd $productDeployListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployListDTO
     */
    public static function productDeployList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UndertakePage\ProductDeployListCmd $productDeployListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productDeployList($productDeployListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployListDTO"
        );
    }


    /**
     * 获取全部产品配置列表(暂时为修修兽定制)
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployClassificationInfoDTO[]
     */
    public static function productDeployListAllGroupByClassification (string $brand, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productDeployListAllGroupByClassification([
                            "brand" => $brand,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ProductDeployClassificationInfoDTO[]"
        );
    }

    /**
     * 获取资源位配置v1
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ResourcePositionInfoDTO[]
     */
    public static function resourceDataV1 (string $brand, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->resourceDataV1([
                            "brand" => $brand,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UndertakePage\ResourcePositionInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\UndertakePage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\UndertakePage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}