<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method couponListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $params)
 * @method receiveCouponByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $params)
 * @method couponListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $params)
 * @method receiveCouponV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 优惠券列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
     */
    public static function couponList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->couponList($couponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }


    /**
     * 领取优惠券
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO
     */
    public static function receiveCoupon (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->receiveCoupon($receiveCouponCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO"
        );
    }


    /**
     * 优惠券列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
     */
    public static function couponListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->couponListV1($couponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }


    /**
     * 领取优惠券 - v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO
     */
    public static function receiveCouponV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->receiveCouponV1($receiveCouponCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}