<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method listWithUserIdByParams(array $params)
 * @method listV1ByParams(array $params)
 */
class OrderMarketingActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单活动列表
     *
     * @support  array $orderIds 多个订单id [ require false ]
     * @support  array $orderNums 多个订单号 [ require false ]
     * @support  string $platform 用户平台，【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】 [ require true ]
     * @support  string $position 用户所在的页面位置，可参考ElementPositionEnum枚举值【photo_for_download 下载成片】【order_list 订单列表】【share_page 分享页】【payment_success 预约成功页】 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO"
        );
    }

    /**
     * 订单活动列表.bridge
     *
     * @support  int $userId 用户id [ require true ]
     * @support  array $orderIds 多个订单id [ require false ]
     * @support  array $orderNums 多个订单号 [ require false ]
     * @support  string $platform 用户平台，【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】 [ require true ]
     * @support  string $position 用户所在的页面位置，可参考ElementPositionEnum枚举值【photo_for_download 下载成片】【order_list 订单列表】【share_page 分享页】【payment_success 预约成功页】 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO
     */
    public static function listWithUserId () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithUserId([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO"
        );
    }

    /**
     * 订单活动列表 - v1
     *
     * @support  array $orderIds 多个订单id [ require false ]
     * @support  array $orderNums 多个订单号 [ require false ]
     * @support  string $platform 用户平台，【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】 [ require true ]
     * @support  string $position 用户所在的页面位置，可参考ElementPositionEnum枚举值【photo_for_download 下载成片】【order_list 订单列表】【share_page 分享页】【payment_success 预约成功页】 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityInfoDTO[]
     */
    public static function listV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderMarketingActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderMarketingActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}