<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexOrderByParams(array $params)
 * @method isShowCpMemberLayerByParams(array $params)
 * @method getIndexOrderV1ByParams(array $params)
 * @method isShowCpMemberLayerV1ByParams(array $params)
 * @method getOrderListJumpListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\JumpPageCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得首页订单
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrder () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexOrder(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }

    /**
     * 是否显示情侣会员引导弹窗
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  string $orderNum 订单编号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isShowCpMemberLayer () {
        return self::getClass()->isShowCpMemberLayer([
        ]);
    }

    /**
     * 获得首页订单.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrderV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexOrderV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }

    /**
     * 是否显示情侣会员引导弹窗v1
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  string $orderNum 订单编号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isShowCpMemberLayerV1 () {
        return self::getClass()->isShowCpMemberLayerV1([
        ]);
    }

    /**
     * 获取app订单列表是否跳转v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\JumpPageCmd $jumpPageCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO
     */
    public static function getOrderListJumpListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\JumpPageCmd $jumpPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderListJumpListV1($jumpPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}