<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMultiMatchPlansByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $params)
 * @method infoByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $params)
 * @method saveShopCartByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $params)
 * @method updateShopCartByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $params)
 * @method deleteShopCartByParams(array $params)
 * @method updateShopCartMarkByParams(array $params)
 * @method getShopCartMarkByParams(array $params)
 * @method readShopCartMarkByParams(array $params)
 * @method getMultiMatchPlansV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $params)
 * @method infoV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $params)
 * @method saveShopCartV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $params)
 * @method updateShopCartV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $params)
 * @method deleteShopCartV1ByParams(array $params)
 * @method updateShopCartMarkV1ByParams(array $params)
 * @method getShopCartMarkV1ByParams(array $params)
 * @method readShopCartMarkV1ByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取多家推荐门店.排列组合
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO
     */
    public static function getMultiMatchPlans (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiMatchPlans($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO"
        );
    }


    /**
     * 获取购物车内容
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
     */
    public static function info (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }


    /**
     * 加入购物车.新增或者更新
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartAddCmd) {
        return self::getClass()->saveShopCart($shopCartAddCmd);
    }


    /**
     * 更新购物车
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return self::getClass()->updateShopCart($shopCartUpdateCmd);
    }


    /**
     * 删除购物车所选类目
     *
     * @support  array $shopCartIds 拍摄产品/零售 购物车id集合 [ require false ]
     * @support  array $retailIds 套餐或其他的零售购物车ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShopCart () {
        return self::getClass()->deleteShopCart([
        ]);
    }

    /**
     * 更新购物车标记
     *
     * @support  string $brand  [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShopCartMark () {
        return self::getClass()->updateShopCartMark([
        ]);
    }

    /**
     * 获取购物车标记
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getShopCartMark () {
        return self::getClass()->getShopCartMark();
    }

    /**
     * 已读购物车标记
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function readShopCartMark () {
        return self::getClass()->readShopCartMark();
    }

    /**
     * 获取多家推荐门店.排列组合.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO
     */
    public static function getMultiMatchPlansV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiMatchPlansV1($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO"
        );
    }


    /**
     * 获取购物车内容.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
     */
    public static function infoV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->infoV1($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }


    /**
     * 加入购物车.新增或者更新.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartSaveCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartSaveCmd) {
        return self::getClass()->saveShopCartV1($shopCartSaveCmd);
    }


    /**
     * 更新购物车.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return self::getClass()->updateShopCartV1($shopCartUpdateCmd);
    }


    /**
     * 删除购物车所选类目.v1
     *
     * @support  array $shopCartIds 拍摄产品/零售 购物车id集合 [ require false ]
     * @support  array $retailIds 套餐或其他的零售购物车ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShopCartV1 () {
        return self::getClass()->deleteShopCartV1([
        ]);
    }

    /**
     * 更新购物车标记.v1
     *
     * @support  string $brand  [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShopCartMarkV1 () {
        return self::getClass()->updateShopCartMarkV1([
        ]);
    }

    /**
     * 获取购物车标记.v1
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getShopCartMarkV1 () {
        return self::getClass()->getShopCartMarkV1();
    }

    /**
     * 已读购物车标记.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function readShopCartMarkV1 () {
        return self::getClass()->readShopCartMarkV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}