<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenIndexBannerChangeByParams(array $params)
 * @method listenUserBannerChangeByParams(array $params)
 */
class Banner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 首页banner变更
     *
     * @support  string $channel 渠道 [ require true ]
     * @support  string $newCityListType 新的城市类型 [ require false ]
     * @support  array $newCityIds 新的城市Id [ require false ]
     * @support  string $oldCityListType 老的城市类型 [ require false ]
     * @support  array $oldCityIds 老的城市Id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenIndexBannerChange () {
        return self::getClass()->listenIndexBannerChange([
        ]);
    }

    /**
     * user_banner变更
     *
     * @support  string $module 模块 [ require true ]
     * @support  string $newCityListType 新的城市类型 [ require false ]
     * @support  array $newCityIds 新的城市Id [ require false ]
     * @support  string $oldCityListType 老的城市类型 [ require false ]
     * @support  array $oldCityIds 老的城市Id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenUserBannerChange () {
        return self::getClass()->listenUserBannerChange([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\Banner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\Banner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}