<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Activity\CommonActivityCmd $params)
 */
class ActivityCommon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单个通用活动配置
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Activity\CommonActivityCmd $activityCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Activity\ActivityCommonDTO
     */
    public static function getActivityInfo (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Activity\CommonActivityCmd $activityCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo($activityCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Activity\ActivityCommonDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Activity\ActivityCommon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Activity\ActivityCommon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}