<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method historyByParams(array $params)
 * @method createSimpleByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $params)
 * @method getInvoiceListByParams(array $params)
 * @method getHmxStoresByParams(array $params)
 * @method historyV1ByParams(array $params)
 * @method createSimpleV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $params)
 * @method getInvoiceListV1ByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取发票列表.历史列表
     *
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceHistoryListDTO
     */
    public static function history (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->history([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceHistoryListDTO"
        );
    }

    /**
     * 电子发票.开普票
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $invoiceCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createSimple (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $invoiceCreateCmd) {
        return self::getClass()->createSimple($invoiceCreateCmd);
    }


    /**
     * 获取可开票的发票列表
     *
     * @param  int $storeId 门店id [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceListDTO
     */
    public static function getInvoiceList (int $userId, int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceList([
                            "userId" => $userId,
                            "storeId" => $storeId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceListDTO"
        );
    }

    /**
     * 开票主体门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHmxStores () {
        return self::getClass()->getHmxStores();
    }

    /**
     * 获取发票列表.历史列表.v1
     *
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceHistoryListDTO
     */
    public static function historyV1 (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->historyV1([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceHistoryListDTO"
        );
    }

    /**
     * 电子发票.开普票.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $invoiceCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createSimpleV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateCmd $invoiceCreateCmd) {
        return self::getClass()->createSimpleV1($invoiceCreateCmd);
    }


    /**
     * 获取可开票的发票列表.v1
     *
     * @param  int $storeId 门店id [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceListDTO
     */
    public static function getInvoiceListV1 (int $userId, int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceListV1([
                            "userId" => $userId,
                            "storeId" => $storeId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}