<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderCloudMusicMembersByParams(array $params)
 * @method queryExchangingCloudMusicOrdersByParams(array $params)
 */
class CloudMusicCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天1点10分的时候执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrderCloudMusicMembers () {
        return self::getClass()->createOrderCloudMusicMembers();
    }

    /**
     * 每天1点15分执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function queryExchangingCloudMusicOrders () {
        return self::getClass()->queryExchangingCloudMusicOrders();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Cron\CloudMusicCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Cron\CloudMusicCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}