<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendSingleTypeKfMsgByParams(array $params)
 */
class KfMsg {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送单条微信客服消息
     *
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $item 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $appName 应用名称 [ require true ]
     * @param  array $content 发送消息 [ require true ]
     * @param  int $msgType 消息类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendSingleTypeKfMsg (int $type, string $item, string $appName, array $content, int $msgType) {
        return self::getClass()->sendSingleTypeKfMsg([
            "type" => $type,
            "item" => $item,
            "appName" => $appName,
            "content" => $content,
            "msgType" => $msgType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\KfMsg');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\KfMsg');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}