<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexArticleByParams(array $params)
 * @method getIndexArticleCategoryListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $params)
 * @method getIndexArticleListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $params)
 * @method getIndexArticleDetailByParams(array $params)
 * @method bannersByParams(array $params)
 * @method getHotProductsByParams(array $params)
 * @method getIndexArticleV1ByParams(array $params)
 * @method getIndexArticleCategoryListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $params)
 * @method getIndexArticleListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $params)
 * @method getIndexArticleDetailV1ByParams(array $params)
 * @method bannersV1ByParams(array $params)
 * @method getHotProductsV1ByParams(array $params)
 */
class Index {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 首页热门资讯
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO[]
     */
    public static function getIndexArticle (int $cityId = 0, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticle([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO[]"
        );
    }

    /**
     * 文章类目列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $articleCategoryListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\ArticleCategoryListDTO
     */
    public static function getIndexArticleCategoryList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $articleCategoryListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleCategoryList($articleCategoryListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\ArticleCategoryListDTO"
        );
    }


    /**
     * 首页热门资讯列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $indexArticleListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleListDTO
     */
    public static function getIndexArticleList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $indexArticleListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleList($indexArticleListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleListDTO"
        );
    }


    /**
     * 首页热门资讯详情
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO
     */
    public static function getIndexArticleDetail (int $cityArticleId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleDetail([
                            "cityArticleId" => $cityArticleId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO"
        );
    }

    /**
     * 首页banner
     *
     * @param  int $cityId 当前城市id [ require true ]
     * @param  string $channel 模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexBannerDTO
     */
    public static function banners (int $cityId, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->banners([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexBannerDTO"
        );
    }

    /**
     * 热门产品推荐
     *
     * @support  int $cityId 当前城市id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\HotProductDTO[]
     */
    public static function getHotProducts () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHotProducts([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\HotProductDTO[]"
        );
    }

    /**
     * 首页热门资讯.v1
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO[]
     */
    public static function getIndexArticleV1 (int $cityId = 0, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleV1([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO[]"
        );
    }

    /**
     * 文章类目列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $articleCategoryListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\ArticleCategoryListDTO
     */
    public static function getIndexArticleCategoryListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\ArticleCategoryListCmd $articleCategoryListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleCategoryListV1($articleCategoryListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\ArticleCategoryListDTO"
        );
    }


    /**
     * 首页热门资讯列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $indexArticleListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleListDTO
     */
    public static function getIndexArticleListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Index\IndexArticleListCmd $indexArticleListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleListV1($indexArticleListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleListDTO"
        );
    }


    /**
     * 首页热门资讯详情.v1
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO
     */
    public static function getIndexArticleDetailV1 (int $cityArticleId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexArticleDetailV1([
                            "cityArticleId" => $cityArticleId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexArticleDTO"
        );
    }

    /**
     * 首页banner.v1
     *
     * @param  int $cityId 当前城市id [ require true ]
     * @param  string $channel 模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexBannerDTO
     */
    public static function bannersV1 (int $cityId, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bannersV1([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\IndexBannerDTO"
        );
    }

    /**
     * 热门产品推荐.v1
     *
     * @support  int $cityId 当前城市id [ require true ]
     * @support  string $channel 渠道 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\HotProductDTO[]
     */
    public static function getHotProductsV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHotProductsV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\HotProductDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Index\Index');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Index\Index');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}