<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWxMiniSchemeByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxSchemeCmd $params)
 * @method getWxMiniUrlLinkByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCmd $params)
 */
class Wx {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成小程序scheme码
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxSchemeCmd $wxSchemeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\WxSchemeDTO
     */
    public static function getWxMiniScheme (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxSchemeCmd $wxSchemeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getWxMiniScheme($wxSchemeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\WxSchemeDTO"
        );
    }


    /**
     * 生成小程序UrlLink
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCmd $wxUrlLinkCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\WxUrlLinkDTO
     */
    public static function getWxMiniUrlLink (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCmd $wxUrlLinkCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getWxMiniUrlLink($wxUrlLinkCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\WxUrlLinkDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}