<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendSmsCodeWithoutCaptionByParams(array $params)
 * @method sendSmsCodeByTokenByParams(array $params)
 */
class Sms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送短信code
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendSmsCodeWithoutCaption (string $type, string $phone) {
        return self::getClass()->sendSmsCodeWithoutCaption([
            "type" => $type,
            "phone" => $phone,
        ]);
    }

    /**
     * 通过token发送短信code
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $token token [ require true ]
     * @param  string $tokenType token类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendSmsCodeByToken (string $type, string $phone, string $token, string $tokenType = '') {
        return self::getClass()->sendSmsCodeByToken([
            "type" => $type,
            "phone" => $phone,
            "token" => $token,
            "tokenType" => $tokenType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\Sms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\Sms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}