<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendRefundingNotifyByParams(array $params)
 * @method sendRefundSuccessNotifyByParams(array $params)
 * @method sendPaidSuccessNotifyByParams(array $params)
 */
class AggregateOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 聚合订单-退款申请事件
     *
     * @support  string $aggregateOrderNo 聚合订单的订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendRefundingNotify () {
        return self::getClass()->sendRefundingNotify([
        ]);
    }

    /**
     * 聚合订单-退款成功事件
     *
     * @support  string $aggregateOrderNo 聚合订单的订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendRefundSuccessNotify () {
        return self::getClass()->sendRefundSuccessNotify([
        ]);
    }

    /**
     * 聚合订单-支付抖音订单事件
     *
     * @support  string $aggregateOrderNo 聚合订单的订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendPaidSuccessNotify () {
        return self::getClass()->sendPaidSuccessNotify([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\AggregateOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\AggregateOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}