<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $params)
 * @method getMultiReservationListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $params)
 * @method createOrderOccupyNumByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $params)
 * @method appointmentStateByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $params)
 * @method getMultiReservationListByPageByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $params)
 * @method getSaleSameProductStoresByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $params)
 * @method getReservationListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $params)
 * @method getMultiReservationListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $params)
 * @method getMultiReservationListByPageV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $params)
 * @method createOrderOccupyNumV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $params)
 * @method appointmentStateV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $params)
 * @method getSaleSameProductStoresV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表-单门店
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]
     */
    public static function getReservationList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReservationList($reservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]"
        );
    }


    /**
     * 排单表-多门店
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]
     */
    public static function getMultiReservationList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiReservationList($multiReservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]"
        );
    }


    /**
     * 校验订单是否可下单
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrderOccupyNum (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd) {
        return self::getClass()->createOrderOccupyNum($orderOccupyNumCmd);
    }


    /**
     * 根据日期期间获取是否已约满的状态
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]
     */
    public static function appointmentState (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->appointmentState($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }


    /**
     * 排单表-多门店-分页
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO
     */
    public static function getMultiReservationListByPage (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiReservationListByPage($multiReservationListByPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO"
        );
    }


    /**
     * 获取可拍摄门店IDs
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function getSaleSameProductStores (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd) {
        return self::getClass()->getSaleSameProductStores($saleSameProductStoresCmd);
    }


    /**
     * 排单表-单门店.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]
     */
    public static function getReservationListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReservationListV1($reservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationInfoDTO[]"
        );
    }


    /**
     * 排单表-多门店.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]
     */
    public static function getMultiReservationListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListCmd $multiReservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiReservationListV1($multiReservationListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoreInfoDTO[]"
        );
    }


    /**
     * 排单表-多门店-分页.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO
     */
    public static function getMultiReservationListByPageV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\MultiReservationListByPageCmd $multiReservationListByPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMultiReservationListByPageV1($multiReservationListByPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\ReservationStoresDTO"
        );
    }


    /**
     * 校验订单是否可下单.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrderOccupyNumV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\OrderOccupyNumCmd $orderOccupyNumCmd) {
        return self::getClass()->createOrderOccupyNumV1($orderOccupyNumCmd);
    }


    /**
     * 根据日期期间获取是否已约满的状态.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]
     */
    public static function appointmentStateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationListBaseCmd $reservationListBaseCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->appointmentStateV1($reservationListBaseCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }


    /**
     * 获取可拍摄门店IDs-v1版本
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function getSaleSameProductStoresV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\SaleSameProductStoresCmd $saleSameProductStoresCmd) {
        return self::getClass()->getSaleSameProductStoresV1($saleSameProductStoresCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}