<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCitiesByStoreTypeByParams(array $params)
 * @method getStoreListByCityIdByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\GetStoreListByCityIdCmd $params)
 * @method getStoreInfoByParams(array $params)
 * @method getStoreIdsHaveSameProductByParams(array $params)
 * @method getStoreIdsHaveSameProductByCityIdByParams(array $params)
 * @method getStoreIdsHaveSameCategoryByParams(array $params)
 * @method getStoreListByIdsByParams(array $params)
 * @method getMostNearestStoreByParams(array $params)
 * @method getStoreTypesByParams(array $params)
 * @method getCitiesByStoreTypeV1ByParams(array $params)
 * @method getStoreListByCityIdV1ByParams(array $params)
 * @method getStoreInfoV1ByParams(array $params)
 * @method getStoreTypesV1ByParams(array $params)
 * @method getCitiesByStoreTypeV2ByParams(array $params)
 * @method getStoreListByCityIdV2ByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前有门店的所有城市
     *
     * @support  array $storeType 门店类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]
     */
    public static function getCitiesByStoreType () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCitiesByStoreType([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表[crm也在使用]
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\GetStoreListByCityIdCmd $getStoreListByCityIdCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]
     */
    public static function getStoreListByCityId (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\GetStoreListByCityIdCmd $getStoreListByCityIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByCityId($getStoreListByCityIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }


    /**
     * 根据门店id获取门店详情
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
     */
    public static function getStoreInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreInfo([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }

    /**
     * 获取有该产品的门店ids
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getStoreIdsHaveSameProduct () {
        return self::getClass()->getStoreIdsHaveSameProduct([
        ]);
    }

    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     *
     * @support  int $nodeId 产品id或者Category id [ require true ]
     * @support  string $type 查询类型 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getStoreIdsHaveSameProductByCityId () {
        return self::getClass()->getStoreIdsHaveSameProductByCityId([
        ]);
    }

    /**
     * 获取当前城市包含这个类目 中 任意 产品的门店ids
     *
     * @support  int $categoryId 产品组id [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getStoreIdsHaveSameCategory () {
        return self::getClass()->getStoreIdsHaveSameCategory([
        ]);
    }

    /**
     * 根据门店ids获取门店信息
     *
     * @support  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreListByIds () {
        return self::getClass()->getStoreListByIds([
        ]);
    }

    /**
     * 获取距离最近的门店[crm也在使用]
     *
     * @param  array $location 地理位置,[125,30] [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO
     */
    public static function getMostNearestStore (array $location, string $brand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMostNearestStore([
                            "location" => $location,
                            "brand" => $brand,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO"
        );
    }

    /**
     * 获取门店tab类型
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]
     */
    public static function getStoreTypes () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreTypes(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }

    /**
     * 获取当前有门店的所有城市.v1
     *
     * @support  array $storeType 门店类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]
     */
    public static function getCitiesByStoreTypeV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCitiesByStoreTypeV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表.v1
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]
     */
    public static function getStoreListByCityIdV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByCityIdV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * 根据门店id获取门店详情.v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
     */
    public static function getStoreInfoV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreInfoV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }

    /**
     * 获取门店tab类型v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]
     */
    public static function getStoreTypesV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreTypesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }

    /**
     * 获取当前有门店的所有城市.v2
     *
     * @support  array $storeType 门店类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]
     */
    public static function getCitiesByStoreTypeV2 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCitiesByStoreTypeV2([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表.v2
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @support  array $storeType 门店类型 [ require false ]
     * @support  string $type 获取数据基本类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]
     */
    public static function getStoreListByCityIdV2 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByCityIdV2([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}