<?php
namespace Mainto\Bridge\Enums\AppointmentPlatform\User;

class BirthGiftStatusEnum {
    /**
     * 无生日礼遇
     */
    const NONE = 'none';
    /**
     * 有生日礼遇，但没有兑换资格
     */
    const PRECONDITION = 'precondition';
    /**
     * 有生日礼遇，但没有兑换
     */
    const WAITING = 'waiting';
    /**
     * 生日礼遇已兑换，但没有去线下门店提取
     */
    const EXCHANGED = 'exchanged';
    /**
     * 生日礼遇已兑换，但没有去线下门店提取 （兼容，老版本的用户中心，前端是根据received来作为exchanged的判断依据）
     */
    const RECEIVED = 'received';
    /**
     * 生日礼遇已兑换，并已经在线下门店提取完毕
     */
    const VERIFIED = 'verified';
    /**
     * 生日礼遇已兑换，在已超出线下门店提取的有效时间
     */
    const EXPIRED = 'expired';
}