<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method threeHourReminderByParams(array $params)
 * @method dayReminderByParams(array $params)
 * @method sendSNByParams(array $params)
 * @method precisePushByParams(array $params)
 * @method returnGiftCardByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method pushCompleteOrderMessageByParams(array $params)
 * @method syncGeoLocationByParams(array $params)
 * @method lookPhotoAutoCompleteByParams(array $params)
 * @method pictureOnlineLookPhotoAutoCompleteByParams(array $params)
 * @method upgradeSkuAutoCompleteByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每五分钟执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function threeHourReminder () {
        return self::getClass()->threeHourReminder();
    }

    /**
     * 每天11点-18点每小时执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function dayReminder () {
        return self::getClass()->dayReminder();
    }

    /**
     * 每5分钟执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function sendSN () {
        return self::getClass()->sendSN();
    }

    /**
     * 每天晚上九点半执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function precisePush () {
        return self::getClass()->precisePush();
    }

    /**
     * 未接受礼品卡退还
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function returnGiftCard () {
        return self::getClass()->returnGiftCard();
    }

    /**
     * 每天10点04 执行一次, 错峰执行
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function serviceComplete () {
        return self::getClass()->serviceComplete();
    }

    /**
     * 每天12点执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function pushCompleteOrderMessage () {
        return self::getClass()->pushCompleteOrderMessage();
    }

    /**
     * 每天3点同步一次门店经纬度数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncGeoLocation () {
        return self::getClass()->syncGeoLocation();
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function lookPhotoAutoComplete (string $day = '') {
        return self::getClass()->lookPhotoAutoComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pictureOnlineLookPhotoAutoComplete (string $day = '') {
        return self::getClass()->pictureOnlineLookPhotoAutoComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天15点执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function upgradeSkuAutoComplete (string $day = '') {
        return self::getClass()->upgradeSkuAutoComplete([
            "day" => $day,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}