<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderCompleteByParams(array $params)
 * @method creatGifImgByParams(array $params)
 */
class OrderMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单完成推送通知
     *
     * @support  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete([
        ]);
    }

    /**
     * 图片处理
     *
     * @support  string $photoUrl 照片地址 [ require true ]
     * @support  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function creatGifImg () {
        return self::getClass()->creatGifImg([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\OrderMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\OrderMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}