<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRefundInfoByParams(array $params)
 * @method getRefundResultByParams(array $params)
 * @method createRefundByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $params)
 * @method updateRefundByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $params)
 * @method getRefundInfoV1ByParams(array $params)
 * @method getRefundResultV1ByParams(array $params)
 * @method createRefundV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $params)
 * @method updateRefundV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得退款数据
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO
     */
    public static function getRefundInfo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundInfo([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO"
        );
    }

    /**
     * 获得退款结果
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO
     */
    public static function getRefundResult (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundResult([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO"
        );
    }

    /**
     * 订单退款
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd) {
        return self::getClass()->createRefund($refundCreateCmd);
    }


    /**
     * 更新退款帐号
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefund (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd) {
        return self::getClass()->updateRefund($refundUpdateCmd);
    }


    /**
     * 获得退款数据.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO
     */
    public static function getRefundInfoV1 (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundInfoV1([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO"
        );
    }

    /**
     * 获得退款结果.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO
     */
    public static function getRefundResultV1 (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundResultV1([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO"
        );
    }

    /**
     * 订单退款.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefundV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd) {
        return self::getClass()->createRefundV1($refundCreateCmd);
    }


    /**
     * 更新退款帐号.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefundV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd) {
        return self::getClass()->updateRefundV1($refundUpdateCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}