<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method editUserInfoHookByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\MessageQueue\EditUserInfoHookCmd $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修改用户信息hook
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\MessageQueue\EditUserInfoHookCmd $editUserInfoHookCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editUserInfoHook (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\MessageQueue\EditUserInfoHookCmd $editUserInfoHookCmd) {
        return self::getClass()->editUserInfoHook($editUserInfoHookCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}