<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenProductByParams(array $params)
 */
class ProductCache {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 缓存类型
     * 1、产品信息更改
     * 影响:
     * 1、产品详情缓存
     * 2、门店产品缓存
     * 3、门店下的全部产品缓存(刷新有当前产品的门店全部产品缓存)
     * 4、类目详情（刷新当前 更新产品 所在的类目详情）目前都是按照门店产品做的缓存，在找到对应类目信息
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProduct (int $productId) {
        return self::getClass()->listenProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\ProductCache');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\ProductCache');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}