<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method batchDeleteByParams(array $params)
 * @method deleteByParams(array $params)
 * @method createByParams(array $params)
 * @method listV1ByParams(array $params)
 * @method batchDeleteV1ByParams(array $params)
 * @method deleteV1ByParams(array $params)
 * @method createV1ByParams(array $params)
 */
class SearchTerms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取历史搜索词
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchTerm\SearchTermInfoDTO[]
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 批量删除搜索词
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDelete () {
        return self::getClass()->batchDelete();
    }

    /**
     * 删除搜索词
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 添加搜索词
     *
     * @support  string $content 搜索内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取历史搜索词v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchTerm\SearchTermInfoDTO[]
     */
    public static function listV1 () {
        return self::getClass()->listV1();
    }

    /**
     * 批量删除搜索词v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDeleteV1 () {
        return self::getClass()->batchDeleteV1();
    }

    /**
     * 删除搜索词v1
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteV1 () {
        return self::getClass()->deleteV1([
        ]);
    }

    /**
     * 添加搜索词v1
     *
     * @support  string $content 搜索内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createV1 () {
        return self::getClass()->createV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\SearchTerms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\SearchTerms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}