<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenContentLikeByParams(array $params)
 * @method contentStarSendNotifyByParams(array $params)
 */
class Content {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 内容点赞事件监听
     *
     * @param  int $contentUserId 内容用户id [ require true ]
     * @param  int $userId 点赞用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentLike (int $contentUserId, int $userId) {
        return self::getClass()->listenContentLike([
            "contentUserId" => $contentUserId,
            "userId" => $userId,
        ]);
    }

    /**
     * 内容精选事件监听
     *
     * @param  int $contentId 内容id [ require true ]
     * @param  string $productFullName 精选产品名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentStarSendNotify (int $contentId, string $productFullName) {
        return self::getClass()->contentStarSendNotify([
            "contentId" => $contentId,
            "productFullName" => $productFullName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\Content');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\Content');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}