<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Discuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method myListByParams(array $params)
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method deleteByParams(array $params)
 * @method likeByParams(array $params)
 * @method likeCancelByParams(array $params)
 * @method wishListByParams(array $params)
 * @method myWishListByParams(array $params)
 * @method wishAddByParams(array $params)
 * @method wishDetailByParams(array $params)
 */
class Wish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 心愿列表.首页
     *
     * @support  string $status 实现状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 心愿列表.个人列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function myList () {
        return self::getClass()->myList([
        ]);
    }

    /**
     * 心愿添加
     *
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 心愿编辑
     *
     * @support  int $id 心愿id [ require true ]
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 心愿删除
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 心愿点赞
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function like () {
        return self::getClass()->like([
        ]);
    }

    /**
     * 心愿点赞取消
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function likeCancel () {
        return self::getClass()->likeCancel([
        ]);
    }

    /**
     * 心愿列表.首页-dto格式
     *
     * @support  string $status 实现状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishListDTO
     */
    public static function wishList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->wishList([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishListDTO"
        );
    }

    /**
     * 心愿列表.首页-dto格式
     *
     * @support  string $status 实现状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishListDTO
     */
    public static function myWishList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->myWishList([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishListDTO"
        );
    }

    /**
     * 心愿添加
     *
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishDetailDTO
     */
    public static function wishAdd () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->wishAdd([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishDetailDTO"
        );
    }

    /**
     * 心愿详情
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishDetailDTO
     */
    public static function wishDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->wishDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Wish\WishDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Discuss\Wish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Discuss\Wish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}