<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCompleteLookPhotoSaleSkuIdsByParams(array $params)
 * @method saleSkuIdsServiceCompleteByParams(array $params)
 * @method getCompleteLookPhotoSaleSkuIdsV1ByParams(array $params)
 * @method saleSkuIdsServiceCompleteV1ByParams(array $params)
 */
class OrderSalesSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取需要确认sku信息
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCompleteLookPhotoSaleSkuIds (string $orderNo, int $userId) {
        return self::getClass()->getCompleteLookPhotoSaleSkuIds([
            "orderNo" => $orderNo,
            "userId" => $userId,
        ]);
    }

    /**
     * 确认当前订单需要确认的sku信息
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saleSkuIdsServiceComplete (string $orderNo, int $userId) {
        return self::getClass()->saleSkuIdsServiceComplete([
            "orderNo" => $orderNo,
            "userId" => $userId,
        ]);
    }

    /**
     * 获取需要确认sku信息.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCompleteLookPhotoSaleSkuIdsV1 (string $orderNo, int $userId) {
        return self::getClass()->getCompleteLookPhotoSaleSkuIdsV1([
            "orderNo" => $orderNo,
            "userId" => $userId,
        ]);
    }

    /**
     * 确认当前订单需要确认的sku信息.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saleSkuIdsServiceCompleteV1 (string $orderNo, int $userId) {
        return self::getClass()->saleSkuIdsServiceCompleteV1([
            "orderNo" => $orderNo,
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderSalesSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderSalesSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}