<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderMarketingActivityListCmd $params)
 */
class OrderMarketingActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单活动列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderMarketingActivityListCmd $orderActivityListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO
     */
    public static function list (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderMarketingActivityListCmd $orderActivityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($orderActivityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderMarketingActivityListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderMarketingActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderMarketingActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}