<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotWordsByParams(array $params)
 * @method defaultWordByParams(array $params)
 * @method recommendForYouByParams(array $params)
 * @method getConfessionSeasonConfigByParams(array $params)
 * @method hotWordsV1ByParams(array $params)
 * @method defaultWordV1ByParams(array $params)
 * @method recommendForYouV1ByParams(array $params)
 * @method getConfessionSeasonConfigV1ByParams(array $params)
 */
class Config {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取热门搜索
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO
     */
    public static function hotWords () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hotWords(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO"
        );
    }

    /**
     * 获取默认搜索词
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO
     */
    public static function defaultWord () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->defaultWord(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO"
        );
    }

    /**
     * 获取为你推荐
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO
     */
    public static function recommendForYou () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->recommendForYou(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO"
        );
    }

    /**
     * 获取告白季活动配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO
     */
    public static function getConfessionSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getConfessionSeasonConfig(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO"
        );
    }

    /**
     * 获取热门搜索v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO
     */
    public static function hotWordsV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hotWordsV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO"
        );
    }

    /**
     * 获取默认搜索词v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO
     */
    public static function defaultWordV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->defaultWordV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO"
        );
    }

    /**
     * 获取为你推荐v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO
     */
    public static function recommendForYouV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->recommendForYouV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO"
        );
    }

    /**
     * 获取告白季活动配置.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO
     */
    public static function getConfessionSeasonConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getConfessionSeasonConfigV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Config');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Config');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}