<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendNormalNotifyByParams(array $params)
 * @method listenOrderServiceCompletedByParams(array $params)
 * @method sendOrderRefundAsyncNotifyByParams(array $params)
 * @method listenOrderCancelByParams(array $params)
 * @method listenOrderPaidOrderByParams(array $params)
 * @method listenOrderStatusUpdateByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 类型 [ require false ]
     * @support  string $module 订单模块 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify([
        ]);
    }

    /**
     * 监听订单服务完成
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $serviceCompleted 服务完成时间 [ require true ]
     * @support  array $orderBaseInfo 订单基础信息 [ require true ]
     * @support  array $orderSkuList 订单sku数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderServiceCompleted () {
        return self::getClass()->listenOrderServiceCompleted([
        ]);
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  bool $allRefund 是否全部退款了 [ require true ]
     * @support  int $refundId 退款id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendOrderRefundAsyncNotify () {
        return self::getClass()->sendOrderRefundAsyncNotify([
        ]);
    }

    /**
     * 取消订单事件监听
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderCancel (string $orderNo) {
        return self::getClass()->listenOrderCancel([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 监听订单支付事件
     *
     * @support  int $orderId 订单号 [ require true ]
     * @support  string $payType 支付类型 [ require false ]
     * @support  string $paymentNo 支付单号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderPaidOrder () {
        return self::getClass()->listenOrderPaidOrder([
        ]);
    }

    /**
     * 监听订单状态变更事件
     *
     * @support  int $orderId 订单号 [ require true ]
     * @support  string $oldStatus 操作前的订单状态 [ require false ]
     * @support  string $status 操作后的订单状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderStatusUpdate () {
        return self::getClass()->listenOrderStatusUpdate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}